% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.aov_b}
\alias{print.lm_b}
\alias{print.np_glm_b}
\alias{print.lm_b_bma}
\alias{print.glm_b}
\alias{print.mediate_b}
\alias{print.survfit_b}
\title{Print bayesics objects.}
\usage{
\method{print}{aov_b}(x, ...)

\method{print}{lm_b}(x, ...)

\method{print}{np_glm_b}(x, ...)

\method{print}{lm_b_bma}(x, ...)

\method{print}{glm_b}(x, ...)

\method{print}{mediate_b}(x, ...)

\method{print}{survfit_b}(x, ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{...}{optional arguments.}
}
\value{
None
}
\description{
Print bayesics objects.
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
print(fit1)
}

}
