% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_graph.R
\name{task_graph_update_ready}
\alias{task_graph_update_ready}
\title{Find the Next Packages Not Dependent on an Unavailable Package}
\usage{
task_graph_update_ready(
  g,
  v = igraph::V(g),
  dependencies = TRUE,
  status = STATUS$pending
)
}
\arguments{
\item{g}{A dependency graph, as produced with \code{\link[=task_graph_create]{task_graph_create()}}.}

\item{v}{Names or nodes objects of packages whose readiness should be
checked.}

\item{dependencies}{Which dependencies types should be met for a node to be
considered satisfied.}

\item{status}{status name. Nodes in v fill be filtered to consists only nodes
with that status.}
}
\value{
The name of the next package to prioritize
}
\description{
While other packages are in progress, identify tasks with all the
dependencies done and mark them as \code{ready} already has its dependencies
done.
}
\details{
There are helpers defined for particular use cases that strictly rely on the
\code{\link[=task_graph_update_ready]{task_graph_update_ready()}}, they are:
\itemize{
\item \code{task_graph_update_ready_strong()} - List vertices whose strong
dependencies are satisfied.
\item \code{task_graph_update_check_ready()} - List root vertices whose all
dependencies are satisfied.
\item \code{task_graph_update_install_ready()} - List install vertices whose
dependencies are all satisfied
}
}
\keyword{internal}
