% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{cocoPredict}
\alias{cocoPredict}
\title{Prediction for coco objects}
\usage{
cocoPredict(coco.object, newdataset, newlocs, type = 'mean', ...)
}
\arguments{
\item{coco.object}{(\code{S4}) A fitted \link{coco} object.}

\item{newdataset}{(\code{data.frame}) A data.frame containing the covariates present in \code{model.list} at the prediction locations.}

\item{newlocs}{(\code{matrix}) A matrix specifying the prediction locations, matching \code{newdataset} index.}

\item{type}{(\code{character}) Specifies whether to return only the point prediction (\code{'mean'}) or both the point prediction and prediction standard errors (\code{'pred'}).}

\item{...}{Additional arguments. If \code{coco.object} contains multiple realizations, the argument \code{index.pred} can be used to specify which realization of \code{coco.object@z} should be used for predictions.}
}
\value{
A list containing:
\itemize{
\item \code{systematic}: The systematic component of the conditional expectation.
\item \code{stochastic}: The stochastic component of the conditional expectation.
\item \code{sd.pred}: The standard errors, when \code{type = 'pred'} is specified.
}
}
\description{
Computes the conditional expectation and standard errors based on the conditional Gaussian distribution for nonstationary spatial models.
}
\examples{
\dontrun{

# Stationary model

model.list_stat <- list('mean' = 0,
'std.dev' = formula( ~ 1),
'scale' = formula( ~ 1),
'aniso' = 0,
'tilt' = 0,
'smooth' = 3/2,
'nugget' = -Inf)

 
model.list_ns <- list('mean' = 0,
'std.dev' = formula( ~ 1 + cov_x + cov_y),
'scale' = formula( ~ 1 + cov_x + cov_y),
'aniso' = 0,
'tilt' = 0,
'smooth' = 3/2,
'nugget' = -Inf)

coco_object <- coco(type = 'dense',
data = holes[[1]][1:100, ],
locs = as.matrix(holes[[1]][1:100, 1:2]),
z = holes[[1]][1:100, ]$z,
model.list = model.list_stat)

optim_coco_stat <- cocoOptim(coco_object,
boundaries = getBoundaries(coco_object,
lower.value = -3, 3))

coco_preds_stat <- cocoPredict(optim_coco_stat, newdataset = holes[[2]],
newlocs = as.matrix(holes[[2]][, 1:2]),
type = "pred")

# Update model
coco_object@model.list <- model.list_ns

optim_coco_ns <- cocoOptim(coco_object,
boundaries = getBoundaries(coco_object,
lower.value = -3, 3))

coco_preds_ns <- cocoPredict(optim_coco_ns, newdataset = holes[[2]],
newlocs = as.matrix(holes[[2]][, 1:2]),
type = "pred")

par(mfrow = c(1, 3))

fields::quilt.plot(main = "full data", holes[[1]][, 1:2], 
holes[[1]]$z, xlim = c(-1, 1), ylim = c(-1, 1))

fields::quilt.plot(main = "stationary se", holes[[2]][, 1:2], 
coco_preds_stat$sd.pred, xlim = c(-1, 1), ylim = c(-1, 1))
fields::quilt.plot(main = "nonstationary se", holes[[2]][, 1:2], 
coco_preds_ns$sd.pred, xlim = c(-1, 1), ylim = c(-1, 1))


}

}
\author{
Federico Blasi
}
