% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_k.R
\name{model_kselect}
\alias{model_kselect}
\alias{k_strict}
\alias{k_elbow}
\alias{k_silhouette}
\title{Methods for selecting clusters}
\usage{
k_strict(hc, .data)

k_elbow(hc, .data, census, range)

k_silhouette(hc, .data, range)
}
\arguments{
\item{hc}{A hierarchical clustering object.}

\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{census}{A motif census object.}

\item{range}{An integer indicating the maximum number of options to consider.
The minimum of this and the number of nodes in the network is used.}
}
\description{
These functions help select the number of clusters to return from \code{hc},
some hierarchical clustering object:
\itemize{
\item \code{k_strict()} selects a number of clusters in which there is no
distance between cluster members.
\item \code{k_elbow()} selects a number of clusters in which there is
a fair trade-off between parsimony and fit according to the elbow method.
\item \code{k_silhouette()} selects a number of clusters that
optimises the silhouette score.
}

These functions are generally not user-facing but used internally
in e.g. the \verb{*_equivalence()} functions.
}
\references{
\subsection{On the elbow method}{

Thorndike, Robert L. 1953.
"Who Belongs in the Family?".
\emph{Psychometrika}, 18(4): 267–76.
\doi{10.1007/BF02289263}.
}

\subsection{On the silhouette method}{

Rousseeuw, Peter J. 1987.
“Silhouettes: A Graphical Aid to the Interpretation and Validation of Cluster Analysis.”
\emph{Journal of Computational and Applied Mathematics}, 20: 53–65.
\doi{10.1016/0377-0427(87)90125-7}.
}
}
