% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-index.R
\name{gtrack.convert_to_indexed}
\alias{gtrack.convert_to_indexed}
\title{Convert a track to indexed format}
\usage{
gtrack.convert_to_indexed(track = NULL)
}
\arguments{
\item{track}{track name to convert}
}
\value{
None
}
\description{
Converts a per-chromosome track to indexed format (track.dat + track.idx).
}
\details{
This function converts a track from the per-chromosome file format to
single-file indexed format. The indexed format dramatically reduces file descriptor
usage for genomes with many contigs and provides better performance for parallel access.

The function performs the following steps:
\enumerate{
  \item Validates that all per-chromosome files have consistent metadata
  \item Creates track.dat by concatenating all per-chromosome files
  \item Creates track.idx with offset/length information for each chromosome
  \item Uses atomic operations (fsync + rename) to ensure data integrity
  \item Removes the old per-chromosome files after successful conversion
}
}
\examples{
\dontrun{
# Convert a track to indexed format
gtrack.convert_to_indexed("my_track")
}
}
\seealso{
\code{\link{gtrack.create}}, \code{\link{gtrack.create_sparse}}, \code{\link{gtrack.create_dense}}
}
