% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-management.R
\name{gtrack.mv}
\alias{gtrack.mv}
\title{Renames or moves a track}
\usage{
gtrack.mv(src = NULL, dest = NULL)
}
\arguments{
\item{src}{source track name}

\item{dest}{destination track name}
}
\value{
None.
}
\description{
Renames a track or moves it to a different namespace within the same database.
}
\details{
This function renames a track or moves it to a different namespace (directory)
within the same database. The track cannot be moved to a different database.
Use \code{\link{gtrack.copy}} followed by \code{\link{gtrack.rm}} if you need
to move a track between databases.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.create_sparse("test_track", "Test", gintervals(1, 0, 100), 1)
gtrack.mv("test_track", "renamed_track")
gtrack.exists("renamed_track")
gtrack.rm("renamed_track", force = TRUE)

}
\seealso{
\code{\link{gtrack.copy}}, \code{\link{gtrack.rm}},
\code{\link{gtrack.exists}}, \code{\link{gtrack.ls}}
}
\keyword{~track}
