% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.logis_fe.R
\name{summary.logis_fe}
\alias{summary.logis_fe}
\title{Result Summaries of Covariate Estimates from a fitted \code{logis_fe} object}
\usage{
\method{summary}{logis_fe}(object, parm, level = 0.95, test = "wald", null = 0, ...)
}
\arguments{
\item{object}{a model fitted from \code{logis_fe}.}

\item{parm}{Specifies a subset of covariates for which the result summaries should be output.
By default, all covariates are included.}

\item{level}{the confidence level during the hypothesis test, meaning a significance level of \eqn{1 - \text{level}}.
The default value is 0.95.}

\item{test}{a character string specifying the type of testing method. The default is "wald".
\itemize{
\item{\code{"wald"}:} wald test.
\item{\code{"lr"}:} likelihood ratio test.
\item{\code{"score"}:} score test.
}}

\item{null}{a number defining the null hypothesis for the covariate estimates. The default value is \code{0}.}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A data frame containing summary statistics for covariate estimates, with the following columns:
\item{Estimate}{the estimates of covariate coefficients.}
\item{Std.Error}{the standard error of the estimate, included only when \code{test = "wald"}.}
\item{Stat}{the test statistic.}
\item{p value}{the p-value for the hypothesis test.}
\item{CI.upper}{the lower bound of the confidence interval, included only when \code{test = "wald"}.}
\item{CI.lower}{the upper bound of the confidence interval, included only when \code{test = "wald"}.}
}
\description{
Provide the summary statistics for the covariate estimates for a fixed effect logistic model.
}
\examples{
data(ExampleDataBinary)
outcome = ExampleDataBinary$Y
covar = ExampleDataBinary$Z
ProvID = ExampleDataBinary$ProvID

fit_fe <- logis_fe(Y = outcome, Z = covar, ProvID = ProvID, message = FALSE)
summary.wald <- summary(fit_fe, level = 0.95, test = "wald")
summary.wald

}
