% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survstat-backend.R
\name{set_cache_settings}
\alias{set_cache_settings}
\title{Set options for the \code{rsurvstat} cache}
\usage{
set_cache_settings(..., active = NULL, dir = NULL, stale = NULL)
}
\arguments{
\item{...}{you can also submit the settings as a named list.}

\item{active}{boolean (optional), set to FALSE to disable caching}

\item{dir}{file path (optional), the location of the cache}

\item{stale}{numeric (optional), the number of days before a cached item is
considered out of date}
}
\value{
the old cache settings as a list
}
\description{
By default successful requests to \code{SurvStat} are cached for 7 days to prevent
repeated querying of the service. This is stored in the usual R package cache
location by default (e.g. \code{"~/.cache/rsurvstat"} on mac / linux). Caching can
be switched off altogether.
}
\examples{
old_settings = set_cache_settings(active = FALSE)
set_cache_settings(old_settings)
}
\concept{cache}
