% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimCovN}
\alias{SimCovN}
\title{Simulate Covariance Matrices
from the Multivariate Normal Distribution}
\usage{
SimCovN(n, sigma, vcov_sigma_vech_l)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{sigma}{Numeric matrix.
The covariance matrix
(\eqn{\boldsymbol{\Sigma}}).}

\item{vcov_sigma_vech_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_sigma_vech))})
of the sampling variance-covariance matrix of
\eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)}.}
}
\value{
Returns a list of random covariance matrices.
}
\description{
This function simulates random covariance matrices
from the multivariate normal distribution.
The function ensures that the generated covariance matrices
are positive semi-definite.
}
\examples{
n <- 10
sigma <- matrix(
  data = c(
    1.0, 0.5, 0.3,
    0.5, 1.0, 0.4,
    0.3, 0.4, 1.0
  ),
  nrow = 3
)
vcov_sigma_vech_l <- t(
  chol(
    0.001 * diag(3 * (3 + 1) / 2)
  )
)
SimCovN(
  n = n,
  sigma = sigma,
  vcov_sigma_vech_l = vcov_sigma_vech_l
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
