% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_winfapapi.R
\name{get_cd}
\alias{get_cd}
\title{A function to obtain information on the station and on the catchment upstream of the station using the NRFA API}
\usage{
get_cd(station, fields = "feh")
}
\arguments{
\item{station}{the NRFA station(s) number for which the the information is required}

\item{fields}{the type of information which is required. Can be "feh" (default), which outputs a subset of information typically used when applying the flood estimation handbook methods, or "all", which output all information made available in the NRFA API.}
}
\value{
a data.frame of one row with different columns depending on whether fields = "all" or fields = "feh" was selected.
}
\description{
The function queries the NRFA API for for information of a given station. Unlike \code{\link{get_amax}} and \code{\link{get_pot}}, the output of this function is not exactly the same from the output of the \code{\link{read_cd3}} function due to differences in the information made available by the NRFA API
}
\examples{
 cdMult <- get_cd(c(40003,42003), fields = "all")
 ### lots of information on the catchment/station
 ### including information on rejected annual maxima
 cdMult$`40003`$`peak-flow-rejected-amax-years` ## no rejections
 cdMult$`42003`$`peak-flow-rejected-amax-years` ## several rejections
 cd40003 <- get_cd(40003, fields = "feh")
 # less information, mostly the FEH descriptors
 dim(cd40003)
 sapply(cdMult, ncol)

}
\seealso{
\code{\link{read_cd3}}. Information on catchment descriptors river flow gauging in the UK can be found at the National River Flow Archive website \url{https://nrfa.ceh.ac.uk}
}
