% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmModel_estimates.R
\name{lmmModel_estimates}
\alias{lmmModel_estimates}
\alias{lmmModel_estimates.explme}
\alias{lmmModel_estimates.gompertzlme}
\title{Get estimates from a linear mixed model of tumor growth data}
\usage{
lmmModel_estimates(model, robust = FALSE, type = "CR2")

\method{lmmModel_estimates}{explme}(model, robust = FALSE, type = "CR2")

\method{lmmModel_estimates}{gompertzlme}(model, robust = FALSE, type = "CR2")
}
\arguments{
\item{model}{An object of class "lme" representing the linear mixed-effects model fitted by \code{\link[=lmmModel]{lmmModel()}}.}

\item{robust}{If TRUE, sandwich-based robust estimators
of the standard error of the regression coefficient estimates by \code{\link[clubSandwich:conf_int]{clubSandwich::conf_int()}} are provided. Sandwich-based robust estimators
are only available for exponential growth models ('explme').}

\item{type}{Character string specifying which small-sample adjustment should be used when \code{robust = True}. Available options are "CR0", "CR1", "CR1p", "CR1S", "CR2", or "CR3".
See "Details" section of \code{\link[clubSandwich:vcovCR]{clubSandwich::vcovCR()}} for further information.}
}
\value{
A data frame with the estimated values for the coefficients of the tumor growth for each treatment, their standard error,
the standard deviation of the random effects, and the standard deviation of the residuals of the model.
These values can be useful for the power analysis of the model using \code{\link[=APrioriPwr]{APrioriPwr()}}.
}
\description{
\code{lmmModel_estimates} allows the user to easily extract some of the interesting model estimates for further use in other functions,
such as for power calculation.
}
\details{
The model estimates provided by \code{lmmModel_estimates} include:
\itemize{
\item Fixed effect coefficients for the Control, Drug A, Drug B, (Drug C, if present), and Combination groups, respectively.
\item The standard error (se) corresponding to each of the fixed effect coefficients.
\item Standard deviation of the random effects (between-subject variance). Column \code{sd_ranef}.
\item Standard deviation of the residuals (within-subject variance). Column \code{sd_resid}.
}
}
\examples{
data("grwth_data")
# Fit example model
lmm <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination"
  ) 
# Get the estimates
lmmModel_estimates(lmm)
}
