#' Statistical Inference for Persistent Homology in Topological Data Analysis
#'
#' This package aims to be a comprehensive toolset for any
#' useR conducting topological data analysis, specifically via the
#' calculation of persistent homology in a Vietoris-Rips complex.
#' The tools this package currently provides can be conveniently split
#' into three main sections: (1) calculating persistent homology; (2)
#' conducting statistical inference on persistent homology calculations;
#' (3) visualizing persistent homology and statistical inference.
#'
#' @useDynLib TDAstats
#' @importFrom Rcpp sourceCpp
#' @name TDAstats
#' @docType package
NULL
