% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owenvalue.R
\name{owenvalue}
\alias{owenvalue}
\title{Owen value}
\usage{
owenvalue(v, binary = FALSE, partition = NULL, game = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{partition}{A partition of the set of players, as a list of vectors. When not specified, it is taken to be the partition whose only element is the set of all players.}

\item{game}{A logical value. By default, \code{game=FALSE}. If set to \code{TRUE}, the associated quotient game is also returned.}
}
\value{
The corresponding Owen value, as a vector; and, if \code{game=TRUE}, the associated quotient game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game and a partition of the set of players, this function computes the Owen value.
}
\details{
Let \eqn{v \in G^{N}} and let \eqn{C=\{C_{1},\dots,C_{m}\}} be a partition of the set of players.
For each \eqn{T \in 2^{N} \setminus \emptyset}, let \eqn{R'_{T}=\{j : C_{j} \cap T \neq \emptyset\}} and \eqn{R^{T}_{j}=C_{j} \cap T} for each \eqn{j \in \{1,\dots,m\}}.
Being \eqn{c_{T}} the Harsanyi dividend of coalition \eqn{T \in 2^{N}}, the Owen value of each player \eqn{i \in N} is defined as
\deqn{O_{i}(v,C)=\sum_{T \in 2^{N}:j \in R'_{T},i \in R^{T}_{j}}\frac{c_{T}}{|R'_{T}||R^{T}_{j}|}.}
}
\examples{
v <- c(0,0,0,0,30,30,40,40,50,50,60,70,80,90,100) # in lexicographic order
owenvalue(v, partition=list(c(1,3),c(2),c(4)))
owenvalue(v)
round(owenvalue(v),10) == round(shapleyvalue(v),10)
w <- c(0,0,0,0,0,10,10,20,10,20,10,20,10,20,10,20,40,20,40,20,40,
       20,40,20,20,80,60,80,80,60,100) # in lexicographic order
owenvalue(w, partition=list(c(1,2,3),c(4,5)))
}
\references{
Owen, G. (1977). Values of Games with a Priori Unions. In R. Henn and O. Moeschlin (Eds.), \emph{Mathematical Economics and Game Theory} (pp. 76-88), Springer.
}
\seealso{
\link{shapleyvalue}, \link{harsanyidividend}
}
