% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totallybalancedcheck.R
\name{totallybalancedcheck}
\alias{totallybalancedcheck}
\title{Totally balanced check}
\usage{
totallybalancedcheck(
  v,
  game = FALSE,
  binary = FALSE,
  tol = 100 * .Machine$double.eps
)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{game}{A logical value. By default, \code{game=FALSE}. If set to \code{TRUE}, the totally balanced cover of the game is also returned.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
\code{TRUE} if the game is totally balanced, \code{FALSE} otherwise. If \code{game=TRUE}, the totally balanced cover of the game is also returned.
}
\description{
This function checks if the given game is totally balanced and computes its totally balanced cover.
}
\details{
A game \eqn{v \in G^{N}} is totally balanced if all of its subgames are balanced
(the subgame of each coalition \eqn{S \in 2^{N}} with respect to \eqn{v} is defined by
\eqn{v_S(T)=v(T)} for all \eqn{T\in 2^S}).
}
\examples{
totallybalancedcheck(c(0,0,0,0,1/2,0,0,1/2,0,1/2,1/2,1/2,1/2,1/2,1))
totallybalancedcheck(c(0,0,0,0,1,1,0,1,0,0,1,1,1,1,2),game=TRUE)
}
\references{
Maschler, M., Solan, E., & Zamir, S. (2013). \emph{Game Theory}. Cambridge University Press.
}
\seealso{
\link{balancedcheck}, \link{subgame}
}
