% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedshapleyvalue.R
\name{weightedshapleyvalue}
\alias{weightedshapleyvalue}
\title{Positively weighted Shapley value}
\usage{
weightedshapleyvalue(v, binary = FALSE, weights, partition = NULL)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{weights}{The player weights, as a vector of positive numbers.}

\item{partition}{An ordered partition of the set of players, as a list of vectors. When not specified, it is taken to be the partition whose only element is the set of all players.}
}
\value{
The positively weighted Shapley value of the game, as a vector.
}
\description{
Given a game, positive player weights and an ordered partition of the set of players, this function returns the corresponding weighted Shapley value.
}
\details{
A weight system \eqn{\omega} is a pair \eqn{\omega=(\lambda,\mathcal{S})} where \eqn{\lambda=(\lambda_{i})_{i \in N}} is a positive weight vector (\eqn{\lambda_{i}>0} for each \eqn{i \in N}) and \eqn{\mathcal{S}=(S_{1},\dots,S_{m})} is an ordered partition of \eqn{N}.
The weighted Shapley value with weight system \eqn{\omega=(\lambda,\mathcal{S})} is the linear map \eqn{Sh^{\omega}} that assigns to each unanimity game \eqn{u_{T}}, with \eqn{T \in 2^{N} \setminus \emptyset},
the allocations \eqn{Sh^{\omega}_{i}(u_{T})=\frac{\lambda_{i}}{\lambda(T \cap S_{k})}} if \eqn{i \in T \cap S_{k}} and \eqn{Sh^{\omega}_{i}=0} if \eqn{i \notin T \cap S_{k}},
where \eqn{k=\max\{i \in N : S_{i} \cap T \neq \emptyset\}}. Then, for each \eqn{v \in G^{N}} and being \eqn{c_{T}} the Harsanyi dividend of coalition \eqn{T \in 2^{N}},
\deqn{Sh^{\omega}(v)=\sum_{T \in 2^{N} \setminus \emptyset}c_{T}Sh^{\omega}(u_{T}).}
}
\examples{
v <- c(0,0,0,0,0,0,1,0,0,1,3,4,6,8,10)
weightedshapleyvalue(v,binary=TRUE,weights=c(0.5,0.2,0.2,0.1))
w <- c(0,0,0,0,30,30,40,40,50,50,60,70,80,90,100)
weightedshapleyvalue(w,weights=c(1,2,3,4),partition=list(c(1,2),c(3,4)))
}
\references{
Shapley, L. S. (1953). \emph{Additive and non-additive set functions}. PhD thesis, Department of Mathematics, Princeton University.
}
\seealso{
\link{coalitionweightedshapleyvalue}, \link{harsanyidividend}, \link{shapleyvalue}
}
