% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVMVP.R
\docType{package}
\name{TVMVP-package}
\alias{TVMVP-package}
\title{TVMVP: Time-Varying Minimum Variance Portfolio Optimization}
\description{
The TVMVP package provides tools for estimating time-dependent covariance 
matrices using kernel-weighted principal component analysis. These estimates 
can then be used for portfolio optimization in a dynamic setting.
}
\details{
The method involves five steps: (1) determining the number of factors, 
(2) estimating kernel-weighted PCA, (3) regularizing the idiosyncratic error 
covariance, (4) estimating the total covariance matrix, and (5) computing 
optimal portfolio weights.

An optional step includes a hypothesis test to check whether the covariance 
matrix is time-invariant.

The local PCA method, method for determining the number of factors, and 
associated hypothesis test are based on Su and Wang (2017). The approach to 
time-varying portfolio optimization follows Fan et al. (2024). The 
regularisation applied to the residual covariance matrix adopts the technique 
introduced by Chen et al. (2019).

The methodology implemented in this package closely follows Fan et al. (2024).
The original authors provide a Matlab implementation at https://github.com/RuikeWu/TV-MVP.


The default kernel function in the package is the Epanechnikov kernel. Other
kernel functions can also be used, however these are not implemented in the
package. In order to do this, write an R function with an integrable
kernel function and use this as input in the functions with argument
\code{kernel_func}. It should be constructed as \code{custom_kernel <- function(u){...}}.

Similarly, the bandwidth function which is implemented in the package is 
the Silverman's rule of thumb. For most functions, simply set \code{bandwidth}
to your preferred bandwidth, however for \code{\link{expanding_tvmvp}},
only Silverman's is implemented in this version of the package.
}
\section{Authors and Maintainer}{

Authors: Erik Lillrank and Yukai Yang \cr
Maintainer: Erik Lillrank \cr
Department of Statistics, Uppsala University \cr
\email{erik.lillrank@gmail.com}, \email{yukai.yang@statistik.uu.se}
}

\section{Functions}{

\describe{
  \item{\code{\link{determine_factors}}}{Selects the optimal number of factors via an information criterion.}
  \item{\code{\link{hyptest}}}{Hypothesis test for time-invariant covariance matrices. Bootstrap p-values supported.}
  \item{\code{\link{predict_portfolio}}}{Optimizes portfolio weights for out-of-sample prediction of portfolio performance.}
  \item{\code{\link{expanding_tvmvp}}}{Evaluates MVP performance in a expanding window framework.}
  \item{\code{\link{time_varying_cov}}}{Estimates the time-varying covariance matrix.}
  \item{\code{\link{silverman}}}{Silverman's rule of thumb bandwidth formula.}
}
}

\section{Class}{

\describe{
 \item{\code{\link{TVMVP}}}{Time Varying Minimum Variance Portfolio (TVMVP) Class.}
}
}

\section{References}{
 
Lillrank, E. (2025). \ifelse{html}{
    \out{<a href='../doc/thesis.pdf'>A Time-Varying Factor Approach to Covariance Estimation</a>}
  }{Master’s thesis (PDF in inst/doc)}
  
Su, L., & Wang, X. (2017). On time-varying factor models: Estimation and testing. Journal of Econometrics, 198(1), 84–101. 

Fan, Q., Wu, R., Yang, Y., & Zhong, W. (2024). Time-varying minimum variance portfolio. Journal of Econometrics, 239(2), 105339.

Chen, J., Li, D., & Linton, O. (2019). A new semiparametric estimation approach for large dynamic covariance matrices with multiple conditioning variables. Journal of Econometrics, 212(1), 155–176.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/erilill/TV-MVP}
  \item Report bugs at \url{https://github.com/erilill/TV-MVP/issues}
}

}
\author{
\strong{Maintainer}: Erik Lillrank \email{erik.lillrank@gmail.com} (\href{https://orcid.org/0009-0001-3345-7694}{ORCID})

Authors:
\itemize{
  \item Yukai Yang \email{yukai.yang@statistik.uu.se} (\href{https://orcid.org/0000-0002-2623-8549}{ORCID})
}

}
\keyword{package}
