library(TWW)

test_that("TWW 1", {
  fluorescence <- c(-0.094311625, -0.022077977, -0.018940959, -0.013167045,  0.007782761,  0.046403221,  0.112927418,  0.236954113,
                    0.479738750,  0.938835708,  1.821600610,  3.451747880,  6.381471101, 11.318606976, 18.669664284, 27.684433343,
                    36.269197588, 42.479513622, 46.054327283, 47.977882896, 49.141536806, 49.828324910, 50.280629676, 50.552338600,
                    50.731472869, 50.833299572, 50.869115345, 50.895051731, 50.904097158, 50.890804989, 50.895911798, 50.904685027,
                    50.899942221, 50.876866864, 50.878926417, 50.876938783, 50.857835844, 50.858580957, 50.854100495, 50.847128383,
                    50.844847982, 50.851447716, 50.841698121, 50.840564351, 50.826118614, 50.828983069, 50.827490974, 50.820366077,
                    50.823743224, 50.857581865)

  cycle_number <- 1:50

  expect_error(tww(x = cycle_number,y = fluorescence,start = list(40,15.5)),
               "Please ensure the correct number of starting parameters are supplied.
         There must be between 3 and 5 numbers entered in the list.")
})
test_that("TWW 2", {
  fluorescence <- c(-0.094311625, -0.022077977, -0.018940959, -0.013167045,  0.007782761,  0.046403221,  0.112927418,  0.236954113,
                    0.479738750,  0.938835708,  1.821600610,  3.451747880,  6.381471101, 11.318606976, 18.669664284, 27.684433343,
                    36.269197588, 42.479513622, 46.054327283, 47.977882896, 49.141536806, 49.828324910, 50.280629676, 50.552338600,
                    50.731472869, 50.833299572, 50.869115345, 50.895051731, 50.904097158, 50.890804989, 50.895911798, 50.904685027,
                    50.899942221, 50.876866864, 50.878926417, 50.876938783, 50.857835844, 50.858580957, 50.854100495, 50.847128383,
                    50.844847982, 50.851447716, 50.841698121, 50.840564351, 50.826118614, 50.828983069, 50.827490974, 50.820366077,
                    50.823743224, 50.857581865)

  cycle_number <- 1:50

  expect_error(tww(x = cycle_number,y = fluorescence,start = list(40,15.5,0.05,10,3,5)),
               "Please ensure the correct number of starting parameters are supplied.
         There must be between 3 and 5 numbers entered in the list.")
})
test_that("TWW 3", {
  fluorescence <- c(-0.094311625, -0.022077977, -0.018940959, -0.013167045,  0.007782761,  0.046403221,  0.112927418,  0.236954113,
                    0.479738750,  0.938835708,  1.821600610,  3.451747880,  6.381471101, 11.318606976, 18.669664284, 27.684433343,
                    36.269197588, 42.479513622, 46.054327283, 47.977882896, 49.141536806, 49.828324910, 50.280629676, 50.552338600,
                    50.731472869, 50.833299572, 50.869115345, 50.895051731, 50.904097158, 50.890804989, 50.895911798, 50.904685027,
                    50.899942221, 50.876866864, 50.878926417, 50.876938783, 50.857835844, 50.858580957, 50.854100495, 50.847128383,
                    50.844847982, 50.851447716, 50.841698121, 50.840564351, 50.826118614, 50.828983069, 50.827490974, 50.820366077,
                    50.823743224, 50.857581865)

  cycle_number <- 1:50

  expect_error(tww(x = cycle_number,y = fluorescence,start = list(40,-15.5,0.05,10,3)),
               "Theta must be greater than 0.")
})
test_that("TWW 4", {
  fluorescence <- c(-0.094311625, -0.022077977, -0.018940959, -0.013167045,  0.007782761,  0.046403221,  0.112927418,  0.236954113,
                    0.479738750,  0.938835708,  1.821600610,  3.451747880,  6.381471101, 11.318606976, 18.669664284, 27.684433343,
                    36.269197588, 42.479513622, 46.054327283, 47.977882896, 49.141536806, 49.828324910, 50.280629676, 50.552338600,
                    50.731472869, 50.833299572, 50.869115345, 50.895051731, 50.904097158, 50.890804989, 50.895911798, 50.904685027,
                    50.899942221, 50.876866864, 50.878926417, 50.876938783, 50.857835844, 50.858580957, 50.854100495, 50.847128383,
                    50.844847982, 50.851447716, 50.841698121, 50.840564351, 50.826118614, 50.828983069, 50.827490974, 50.820366077,
                    50.823743224, 50.857581865)

  cycle_number <- 1:50

  expect_error(tww(x = cycle_number,y = fluorescence,start = list(40,15.5,0.05,10,-3)),
               "Phi must be greater than 0.")
})
test_that("TWW 5", {
  fluorescence <- c(-0.094311625, -0.022077977, -0.018940959, -0.013167045,  0.007782761,  0.046403221,  0.112927418,  0.236954113,
                    0.479738750,  0.938835708,  1.821600610,  3.451747880,  6.381471101, 11.318606976, 18.669664284, 27.684433343,
                    36.269197588, 42.479513622, 46.054327283, 47.977882896, 49.141536806, 49.828324910, 50.280629676, 50.552338600,
                    50.731472869, 50.833299572, 50.869115345, 50.895051731, 50.904097158, 50.890804989, 50.895911798, 50.904685027,
                    50.899942221, 50.876866864, 50.878926417, 50.876938783, 50.857835844, 50.858580957, 50.854100495, 50.847128383,
                    50.844847982, 50.851447716, 50.841698121, 50.840564351, 50.826118614, 50.828983069, 50.827490974, 50.820366077,
                    50.823743224)

  cycle_number <- 1:50

  expect_error(tww(x = cycle_number,y = fluorescence,start = list(40,15.5,0.05,10,-3)),
               "x and y must be the same length.")
})

#  expect_output() prints specified output?
#  expect_message() displays specified message?
#  expect_warning() displays specified warning?
#  expect_error()


