% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{calculate_fs_metrics_cv}
\alias{calculate_fs_metrics_cv}
\title{Calculate Feature Selection Metrics}
\usage{
calculate_fs_metrics_cv(
  selected_vars,
  true_vars_global,
  total_feature_count_p_val
)
}
\arguments{
\item{selected_vars}{A character vector of selected variable names.}

\item{true_vars_global}{A character vector of the true variable names.}

\item{total_feature_count_p_val}{The total number of candidate features (p).}
}
\value{
A list containing the following numeric elements:
\itemize{
\item \code{TP}: True Positives
\item \code{FP}: False Positives
\item \code{FN}: False Negatives
\item \code{TN}: True Negatives
\item \code{Sens}: Sensitivity (Recall)
\item \code{Spec}: Specificity
\item \code{Prec}: Precision
\item \code{F1}: F1-Score
\item \code{N_Selected}: Total number of selected variables
}
}
\description{
Computes TP, FP, FN, TN, Sensitivity, Specificity, Precision, and F1-Score.
}
\details{
The function handles edge cases where the number of true positives, false
positives, or false negatives is zero to avoid division-by-zero errors in
precision, sensitivity, and F1-score calculations.
}
\note{
Inputs are character vectors; no NA imputation is performed. Division
by zero is guarded with 0-valued metrics as documented.
}
\examples{
# --- Example for an internal function ---
# Imagine our model selected 3 variables: V1, V2, and V10
selected <- c("V1", "V2", "V10")

# And the "true" important variables were V1, V2, V3, and V4
true_set <- c("V1", "V2", "V3", "V4")

# And the total pool of variables was 50
p <- 50

# Calculate the performance metrics
metrics <- calculate_fs_metrics_cv(
  selected_vars = selected,
  true_vars_global = true_set,
  total_feature_count_p_val = p
)

print(metrics)
#> Expected output:
#> $TP
#> [1] 2
#> $FP
#> [1] 1
#> $FN
#> [1] 2
#> $TN
#> [1] 45
#> $Sens
#> [1] 0.5
#> $Spec
#> [1] 0.9782609
#> $Prec
#> [1] 0.6666667
#> $F1
#> [1] 0.5714286
#> $N_Selected
#> [1] 3
}
