% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{null_or}
\alias{null_or}
\alias{\%||\%}
\title{Null-safe (coalescing) operator}
\usage{
a \%||\% b
}
\arguments{
\item{a}{The primary object or value.}

\item{b}{The default object or value to return if \code{a} is \code{NULL}.}
}
\value{
\code{a} if not \code{NULL}, otherwise \code{b}.
}
\description{
Returns the left-hand side (\code{a}) if it is not \code{NULL}, otherwise returns
the right-hand side (\code{b}). This operator is useful for setting default
values in a concise manner.
}
\details{
Null-coalescing operator

This implementation mirrors the behavior of \verb{\%||\%} used in several
R ecosystems (e.g., \code{rlang}, \code{purrr}) but is defined here for
convenience within the \strong{TemporalForest} package.
}
\section{Conflicts}{

The \verb{\%||\%} operator name is also used in packages such as \strong{rlang} and \strong{purrr}.
If you load those packages after \strong{TemporalForest}, they may mask this operator.
To avoid ambiguity, call it explicitly using
\verb{TemporalForest::\\}\%||\%\``.
}

\examples{
a <- NULL
b <- 5
a \%||\% b   # Returns 5

x <- 10
y <- 20
x \%||\% y   # Returns 10

# Safe usage when multiple packages define \%||\%
TemporalForest::`\%||\%`(NULL, "default")
}
