% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covMatAR.R
\name{covMatAR}
\alias{covMatAR}
\title{Generate a covariance matrix with Autoregressive (AR) structure.}
\usage{
covMatAR(p, sigma2 = 1, rho)
}
\arguments{
\item{p}{An integer specifying the number of dimensions of the covariance matrix.}

\item{sigma2}{A numeric value specifying the variance parameter (default = 1).}

\item{rho}{A numeric value specifying the autoregressive coefficient. If not
provided, a random value between 0 and 1 will be generated.

The Autoregressive structure is defined as follows:

\deqn{\Sigma = \Sigma_{AR} = \sigma^2 \begin{bmatrix}
1 & \rho & \rho^2 & \cdots & \rho^{\lvert p-1 \rvert} \\
\rho & 1 & \rho & \cdots & \rho^{\lvert p-2 \rvert} \\
\vdots & \vdots & \vdots & \ddots & \vdots \\
\rho^{\lvert p-1 \rvert}  & \rho^{\lvert p-2 \rvert}  & \rho^{\lvert p-3 \rvert} \cdots & 1
\end{bmatrix}}
where \eqn{\Sigma } is the covariance matrix, \eqn{\sigma^2} is the variance parameter,
and \eqn{\rho } is the correlation parameter.}
}
\value{
A \eqn{p \times p} numeric matrix representing the Autoregressive (AR) covariance structure.
}
\description{
This function generates generates an Autoregressive (AR) covariance structure
matrix of size \eqn{p \times p} based on the specified autoregressive
coefficient (\eqn{\rho}) and variance (\eqn{\sigma^2}).
}
\examples{
# generate a covariance matrix for \eqn{p = 5}, \eqn{\sigma^2 = 1}, and \eqn{\rho = 0.9}.
covMatAR(p = 5, rho = 0.9)

# generate a covariance matrix for \eqn{p = 5},  \eqn{\sigma^2 = 5}, and \eqn{\rho = 0.9}.
covMatAR(p = 5, sigma2 = 5, rho = 0.9)

# generate  covariance matrix for \eqn{p = 5},  and no value is considered for \eqn{\rho}
covMatAR(p = 5)

}
