% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod.matrices.R
\name{mod.matrices}
\alias{mod.matrices}
\title{Create model matrices for Thurstonian modeling}
\usage{
mod.matrices(blocks, itf, model)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{model}{A descriptor for the model. Can be one of `'lmean'`,
`'uc'`, `'irt'` or  `'simple2'`, `'simple3'` or `'simple5'`. The Number behind 
the `'simple'` statement defines the Thurstone case.}
}
\value{
Returns a list of elements containing model matrix information.
}
\description{
This function creates and returns model matrices of Thurstonian model equations.
}
\examples{

# set seed and define blocks
set.seed(1)
blocks <- matrix(sample(1:15,15), ncol = 3)

# define the item-to-factor relation
itf <- rep(1:3,5)

mod.matrices(blocks,itf,'irt')
    
}
