% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TooManyCellsR.R
\name{tooManyCells}
\alias{tooManyCells}
\title{Execute 'too-many-cells'.}
\usage{
tooManyCells(mat, args = c("make-tree"), labels = NULL,
  output = "out", prior = NULL, docker = NULL, mounts = c())
}
\arguments{
\item{mat}{The input Matrix with gene row names and
cell barcode column names.}

\item{args}{The arguments to give to the command line program. See
\url{https://gregoryschwartz.github.io/too-many-cells/} for more information.
Defaults to "make-tree".}

\item{labels}{The input labels data frame with item (cell barcodes) and label
(whatever labels you want to give them, such as tissue of origin, celltype,
etc.) columns. Optional.}

\item{output}{The output folder for the 'too-many-cells' process. Defaults to
"out".}

\item{prior}{The location of the tree that was already made (previous
'too-many-cells' output) so quick visual or pruning changes can be made
without remaking the tree (can potentially save hours).}

\item{docker}{If using 'too-many-cells' with docker, use this argument as the
command to call. For instance, if version 0.2.1.0 was pulled from Docker
Hub, set to "gregoryschwartz/too-many-cells:0.2.1.0".}

\item{mounts}{Additional directories to mount if needed for docker.
The 'prior' argument will automatically mount if specified.}
}
\value{
A list of each output, including the stdout. Reads the
  following files, see \url{https://gregoryschwartz.github.io/too-many-cells/} for
  more details: "dendrogram.svg", "clumpiness.pdf", "projection.pdf",
  "label_projection.pdf", "clumpiness.csv", "cluster_info.csv",
  "node_info.csv", and "cluster_diversity.csv".
}
\description{
This function will run 'too-many-cells' on a Matrix.
  Requires 'TooManyCells' to be installed (follow instructions at
  \url{https://gregoryschwartz.github.io/too-many-cells/} ).
}
\examples{
input <- system.file("extdata", "mat.csv", package="TooManyCellsR")
inputLabels <- system.file("extdata", "labels.csv", package="TooManyCellsR")
df = read.csv(input, row.names = 1, header = TRUE)
mat = Matrix::Matrix(as.matrix(df), sparse = TRUE)
labelsDf = read.csv(inputLabels, header = TRUE)
# Here we draw this small toy example with no filter or normalization, and
# decrease the size of the branches and increase the size of the leaf nodes.
# With non-toy real world single cell data, these options should not be
# necessary.
\dontrun{
res = tooManyCells( mat, labels = labelsDf
                  , args = c( "make-tree"
                            , "--no-filter"
                            , "--normalization", "NoneNorm"
                            , "--draw-max-node-size", "40"
                            , "--draw-max-leaf-node-size", "70"
                            )
                  )
plot(res$treePlot, axes = FALSE)
res$stdout
res$nodeInfo
}
}
