% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToothVolumes.R
\name{ToothVolumes}
\alias{ToothVolumes}
\title{ToothVolumes}
\usage{
ToothVolumes(
  ShapeExt,
  ShapeInn,
  col1 = "gray",
  col2 = "red",
  col3 = "green",
  alpha1 = 1,
  alpha2 = 1,
  alpha3 = 1,
  plot = FALSE
)
}
\arguments{
\item{ShapeExt}{3D mesh: external mesh}

\item{ShapeInn}{3D mesh: internal mesh}

\item{col1}{color of the ShapeExt}

\item{col2}{color of the ShapeInn}

\item{col3}{color of the boolean operation between ShapeExt and ShapeInn}

\item{alpha1}{value to set trasparancy of col1}

\item{alpha2}{value to set trasparancy of col1}

\item{alpha3}{value to set trasparancy of col1}

\item{plot}{logical: if TRUE the volumes are shown}
}
\value{
meshOut: external selected mesh

meshInnT: internal selected mesh

meshDiff: differences between selected meshes

volumeT: volume of the external mesh

volInn:volume of the internal mesh

volDiff: difference between volumeT and volInn
}
\description{
Extract volumes from the object ToothShape
}
\examples{
\donttest{
data("URI1_tooth")
require(morphomap)
Enamel<-URI1_tooth$mesh1
Dentin<-URI1_tooth$mesh2
Pulp<-URI1_tooth$mesh3
outline<-URI1_tooth$outline
set<-URI1_tooth$set

#Unrolling the crown
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "c")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh1$mesh
Internal<-AlignMeshes$almesh2$mesh
#Define 16 cross-sections from the 30\% to the 90\% along the crown
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                bio.len = AlignMeshes$length,start=0.3,end=0.9)
Shape<-ToothShape(Core,num.land = 100,sects_vector = NULL,direction = "a")
volumes<-ToothVolumes(Shape$"out3D",Shape$"inn3D",plot=TRUE)
unlist(volumes[4:6])
}
}
\author{
Antonio Profico; Mathilde Augoyard
}
