% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_manipulation.R
\name{diff_periode}
\alias{diff_periode}
\title{Intervalle entre 2 dates}
\usage{
diff_periode(a, b, frequency_ts)
}
\arguments{
\item{a}{un objet date_ts, c'est-à-dire un vecteur numérique, de préférence
\code{integer} au format \code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{b}{un objet date_ts, c'est-à-dire un vecteur numérique, de préférence
\code{integer} au format \code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{frequency_ts}{un entier qui vaut \code{4L} (ou \code{4.0}) pour les séries
trimestrielles et \code{12L} (ou \code{12.0}) pour les séries mensuelles.}
}
\value{
En sortie, la fonction retourne un entier qui désigne le nombre de
période (mois ou trimestres) qui sépare les 2 dates \code{a} et \code{b}.
}
\description{
Intervalle entre 2 dates
}
\details{
On travaille ici avec des dates au format date_ts, c'est-à-dire qui
passe le test de la fonction \code{assert_date_ts}. Lorsqu'on parle d'intervalle
et de nombre de période entre \code{a} et \code{b}, les bornes sont incluses. Ainsi
\code{diff_periode(2020L, 2020L, 12L)} retourne bien 1L et non 2L ou 0L.
}
\examples{
# Une seule période
diff_periode(a = 2020L, b = 2020L, frequency_ts = 4L)

diff_periode(a = c(2000L, 1L), b = c(2020L, 4L), frequency_ts = 4L)

# Ordre chronologique respecté
diff_periode(a = c(2021L, 5L), b = c(2023L, 8L), frequency_ts = 12L)

# Date inversées
diff_periode(a = c(2023L, 8L), b = c(2021L, 5L), frequency_ts = 12L)

}
