% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcUKLotteryPnL.R
\name{CalcUKLotteryPnL}
\alias{CalcUKLotteryPnL}
\title{PnL calculation for UKLottery backtesting}
\usage{
CalcUKLotteryPnL(backtested_results, plot_results = FALSE)
}
\arguments{
\item{backtested_results}{The UKLottery results backtested against the user input}

\item{plot_results}{(Optional) If TRUE, the P&L historical graphs are plotted, default FALSE}
}
\value{
PnL figures
}
\description{
Calculates the PnL for a pay out structure created during backtesting
}
\examples{

uklottery_results = UKLotteryResults()
user_input = c(5,10,20,30,40,50)
backtested_results = UKLotteryBacktesting(uklottery_results,, user_input)
pnl_result = CalcUKLotteryPnL(backtested_results, plot_results = FALSE)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
