% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOrderTests.R
\name{TreeLRT}
\alias{TreeLRT}
\title{Likelihood Ratio Test for Tree Ordered Alternatives}
\usage{
TreeLRT(sample_data, significance_level, n.boot = 1e+05, seed = NULL)
}
\arguments{
\item{sample_data}{A list of numeric vectors. The first element represents the control group, the others represent treatment groups.}

\item{significance_level}{A numeric value between 0 and 1 specifying the significance level for the test (e.g., 0.05).}

\item{n.boot}{Number of bootstrap replications to estimate the critical value (default is 100000).}

\item{seed}{Optional random seed for reproducibility.}
}
\value{
A character string with the critical value, the LRT test statistic, and the test decision.
}
\description{
Performs a likelihood ratio test for testing the equality of means against tree ordered alternatives.
}
\details{
This test compares the null hypothesis of equal means for all groups to the alternative that the control group mean is less than or equal to the treatment group means under the tree order restriction.

The likelihood ratio statistic is computed using constrained maximum likelihood estimates under the null and tree ordered alternative hypotheses. The critical value is estimated by a bootstrap procedure.
}
\examples{
# Generate data
set.seed(456)
control <- rnorm(10, mean = 5)
treatment1 <- rnorm(10, mean = 6)
treatment2 <- rnorm(10, mean = 7)

sample_data <- list(control, treatment1, treatment2)

# Run LRT at 5\% significance level
TreeLRT(sample_data, 0.05, n.boot = 1000)

\donttest{
TreeLRT(sample_data, 0.05, n.boot = 100000)
}
}
\seealso{
Halder, Mondal, and Kumar (2025) "Testing Against Tree Ordered Alternatives in One-way ANOVA" <https://arxiv.org/abs/2507.17229>
}
\author{
Subha Halder
}
