% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial_regression.R
\name{polynomial_regression}
\alias{polynomial_regression}
\title{Multivariate Polynomial Regression}
\usage{
polynomial_regression(data, degree, learn = FALSE, waiting = TRUE)
}
\arguments{
\item{data}{x*y data frame with already classified observations. Each column
represents a parameter of the values (independent variable). The last column
represents the classification value (dependent variable). Each row is a different observation.}

\item{degree}{Degree of the equations approximation.}

\item{learn}{Boolean value. If it is set to "TRUE" multiple clarifications
and explanations are printed along the code}

\item{waiting}{If TRUE while \code{learn} = TRUE. The code will stop in each
"block" of code and wait for the user to press "enter" to continue.}
}
\value{
List containing a list for each independent variable,
 each one contains the equation coefficients.
}
\description{
Calculates and plots the polynomial regression of a given set of values.
Being all of them independent values but one, which is the dependent value.
It provides (if asked) information about the process and intermediate values used to calculate the line equation.
The approximation depends entirely in the \code{degree} of the equations.
}
\examples{
# example code
polynomial_regression(db1rl,4, TRUE, FALSE)
polynomial_regression(db1rl,6)

}
\author{
Víctor Amador Padilla, \email{victor.amador@edu.uah.es}
}
