% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pcawg_value.R
\name{vis_pcawg_dist}
\alias{vis_pcawg_dist}
\title{Visualize molecular profile in PCAWG}
\usage{
vis_pcawg_dist(
  Gene = "TP53",
  Mode = c("Boxplot", "Violinplot"),
  data_type = "mRNA",
  Show.P.value = TRUE,
  Show.P.label = TRUE,
  Method = c("wilcox.test", "t.test"),
  values = c("#DF2020", "#DDDF21"),
  draw_quantiles = c(0.25, 0.5, 0.75),
  trim = TRUE,
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{Mode}{"Boxplot" or "Violinplot" to represent data}

\item{data_type}{choose gene profile type,
including "mRNA", "transcript", "protein", "mutation", "cnv", "methylation", "miRNA".}

\item{Show.P.value}{\code{TRUE} or \code{FALSE} whether to count P value}

\item{Show.P.label}{\code{TRUE} or \code{FALSE} present p value with number or label \code{*}, \verb{**}, \verb{***} and \verb{****}}

\item{Method}{default method is wilcox.test}

\item{values}{the color to fill tumor or normal}

\item{draw_quantiles}{draw quantiles for violinplot}

\item{trim}{whether trim the violin}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\value{
a \code{ggplot} object
}
\description{
Visualize molecular profile in PCAWG
}
\examples{
\dontrun{
p <- vis_pcawg_dist(Gene = "TP53")
}
}
