% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UPCM.R
\name{UPCM}
\alias{UPCM}
\title{Uncertainty in (Generalized) Partial Credit Models}
\usage{
UPCM(
  Y,
  X = NULL,
  GPCM = TRUE,
  Q = 10,
  cores = 2,
  lambda = 0.01,
  se = TRUE,
  method = c("nlminb", "L-BFGS-B"),
  ctrl.nlminb = list(eval.max = 200, iter.max = 150, abs.tol = 1e-08, rel.tol = 1e-08,
    trace = 0, step.min = 0.1, x.tol = 1e-08, xf.tol = 1e-08)
)
}
\arguments{
\item{Y}{Matrix containing the ordinal item response data (as ordered factors), 
one row per observation, one column per item.}

\item{X}{Matrix containing explanatory variables which are used both for 
trait parameters and uncertainty parameters, one row per observation, one column per variable.}

\item{GPCM}{Specifies the baseline model. \code{GPCM = TRUE} results in a \code{UGPCM} while  \code{GPCM = FALSE} results in a \code{UPCM}.}

\item{Q}{Number of nodes to be used (per dimension) in two-dimensional Gauss-Hermite-Quadrature.}

\item{cores}{Number of cores to be used in parallelized computation}

\item{lambda}{Tuning parameter for ridge penalty on all coefficients except sigma/slope parameters. Should be small, only used to stabilize results.}

\item{se}{Should standard errors be computed? Standard errors are necessary for \code{\link{plot.UPCM}}. Computation is 
time-consuming because numerical optimization methods are used.}

\item{method}{Specifies optimization algorithm used , either \code{\link{nlminb}} or \code{L-BFGS-B (\link{optim})}.}

\item{ctrl.nlminb}{List of control arguments for optimization procedure \code{\link{nlminb}}.}
}
\value{
\item{delta}{Matrix containing all item parameters for the UPCM pr UGPCM model, one row
per item, one column per category.} 
\item{Sigma}{2*2 covariance matrix for both random effects, namely the trait parameters theta and the
uncertainty parameters alpha.}
\item{xi}{Estimates for covariate effects on trait parameters.}
\item{alpha}{Estimates for covariate effects on uncertainty parameters.}
\item{slopes}{Estimates item slope parameters (only for \code{GPCM = TRUE}).}
\item{se.delta}{}
\item{se.xi}{Estimates of standard errors for covariate effects on trait parameters.}
\item{se.alpha}{Estimates of standard errors for covariate effects on uncertainty parameters.}
\item{se.sigma}{Estimates of standard errors for covariance parameters. Attention: First and third parameter are estimates of se for
both variances, the variance of theta and the variance of alpha. Second parameter is the estimate for correlation coefficient between theta and alpha, 
NOT of the corresponding covariance.}
\item{se.slopes}{Estimates of standard errors of item slope parameters (only for \code{GPCM = TRUE}).}
\item{delta.GPCM}{Estimates of item parameters theta in the PCM or GPCM model.}
\item{sigma.GPCM}{Estimate of variance of  trait parameters theta in the PCM or GPCM model.}
\item{slopes.GPCM}{Estimates of slope parameters in the GPCM (only for \code{GPCM = TRUE}).}
\item{Y}{Matrix containing the ordinal item response data, one row per obeservation, one column per item.} 
\item{loglik}{Marginal log-likelihood}
\item{coefs}{Complete vector of all estimated parameters (for internal use).}
\item{se.vec}{Complete vector of all estimated standard errors (for internal use).}
}
\description{
Performs UPCM, a method to model uncertainty in (Generalized) Partial Credit Models
}
\examples{
\donttest{
data(tenseness)

Y <- data.matrix(tenseness[,1:4])
X <- model.matrix(~ Gender + Age, data = tenseness)[,-1]

m_upcm <- UPCM(Y = Y, X = X, cores = 2, GPCM = FALSE)
m_upcm
plot(m_upcm)
}
\dontshow{
set.seed(1860, sample.kind = "Rounding")
n <- 70
I <- 2
Y <- matrix(sample(1:3, I*n, replace = TRUE), ncol = I)
m_upcm <- UPCM(Y = Y, cores = 2, GPCM = FALSE, se = FALSE, Q = 6, ctrl.nlminb = list(rel.tol = 1e-06))
}
}
\references{
Tutz, Gerhard and Schauberger, Gunther (2020): Uncertainty in Latent Trait Models, 
\emph{Applied Psychological Measurement}, \url{https://journals.sagepub.com/doi/abs/10.1177/0146621620920932?journalCode=apma}
}
\seealso{
\code{\link{plot.UPCM}} \code{\link{UPCM-package}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}\cr
\url{https://www.sg.tum.de/epidemiologie/team/schauberger/}
}
\keyword{UPCM}
