% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us_cities.R
\name{us_cities}
\alias{us_cities}
\title{City locations and populations (historical and contemporary)}
\usage{
us_cities(map_date = NULL, states = NULL)
}
\arguments{
\item{map_date}{If \code{NULL}, then city populations from the 2010 census
(the most recent census) are returned. This parameter accepts a \code{Date}
object or a character string coercible to a \code{Date} object, as well as
numeric values representing a year. If a year or date is used, then city
populations from the decennial census from 1790 to 2010 \emph{prior} to
that year is returned. For example, \code{1805} or \code{"1805-07-04"}
would return city populations from the 1800 census.}

\item{states}{A character vector of state or territory names or
abbreviations. Only boundaries for those states/territories will be
returned. If \code{NULL}, all boundaries will be returned.}
}
\value{
An \code{sf} object.
}
\description{
This function returns an \code{sf} object of cities (or populated places)
with their populations and latitudes and longitudes. Population data is taken
from the U.S. Census.
}
\examples{
if (require(USAboundariesData, quietly = TRUE)) {
  us_cities(1805)
  us_cities("1828-05-08")
  us_cities()
}

}
\references{
The data was compiled by Erik Steiner and Jason Heppler at the
  Center for Spatial and Textual Analysis, Stanford University. See their
  \href{https://github.com/cestastanford/historical-us-city-populations}{the
  description of the data} for a fuller accounting of how the data was
  gathered.
}
