% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_uvb.R
\name{daily_uvb}
\alias{daily_uvb}
\title{Daily UVB}
\usage{
daily_uvb(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{A date vector, usually date of assessment or recruitment.}

\item{longitude}{A numeric vector of longitude values.}

\item{latitude}{A numeric vector of latitude values.}

\item{temis_path}{Path to TEMIS UV files downloaded using \link{temis_uvdvc}. Default is current directory.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of daily ambient UVB dose measurements.
}
\description{
This function extracts total daily vitamin D-effective UVB dose on a given date and geographical location (longitude and latitude).
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("1000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uvb_example <- system.file("extdata", "uvb_example", package="UVdose")
daily_uvb(mysample, date, longitude, latitude, temis_path = uvb_example)

}
