% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modified.chisq.statistic.R
\name{modified.chisq.statistic}
\alias{modified.chisq.statistic}
\title{Zero-Tolerant Pearson's Chi-squared Statistic}
\usage{
modified.chisq.statistic(x)
}
\arguments{
\item{x}{a matrix or data frame of floating or integer
numbers to specify a contingency table. Entries
must be non-negative.}
}
\value{
The numeric value of the modified Pearson's chi-squared test statistic.
}
\description{
Calculates Pearson's chi-squared test statistic for contingency tables, 
  ignoring entries with zero-expected count.
}
\details{
This test is useful if \emph{p}-value must be returned
  on a contingency table with valid non-negative counts,
  where the build-in R implementation of 
  \code{\link[stats]{chisq.test}} could return \code{NA}
  as \emph{p}-value, regardless of a pattern being
  strong or weak. See Examples.
  
  Unlike \code{\link[stats]{chisq.test}}, this
  function handles tables with empty rows or columns (where
  expected values are 0) by calculating the test
  statistic over non-zero entries only. This prevents
  the result from becoming \code{NA}, while giving
  meaningful \emph{p}-values.
}
\note{
This function only takes contingency table
  as input. It does not support goodness-of-fit
  test on vectors.
  It does \strong{not} offer an option
  to apply Yates's continuity correction 
  on 2 \eqn{\times} 2 tables.
}
\examples{
library("Upsilon")

# Create a table with empty rows or columns
x <- matrix(c(0, 3, 0, 3, 0, 0), nrow = 2, byrow = TRUE)
print(x)

# Standard chisq.test might warn or fail on a table with empty rows or columns
chisq.test(x) 

# Modified statistic handles it gracefully
modified.chisq.statistic(x)
}
\references{
\insertRef{luo2021upsilon}{Upsilon}
}
\keyword{internal}
