% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsilon.gof.statistic.R
\name{upsilon.gof.statistic}
\alias{upsilon.gof.statistic}
\title{Upsilon Goodness-of-Fit Test Statistic}
\usage{
upsilon.gof.statistic(x, p = rep(1/length(x), length(x)), rescale.p = TRUE)
}
\arguments{
\item{x}{a numeric vector or one-column matrix 
representing observed counts.}

\item{p}{a numeric vector of probabilities 
of the same length as \code{x}. 
       Defaults to a uniform distribution (1/length(x)).}

\item{rescale.p}{a logical scalar. 
If \code{TRUE} (default), \code{p} is rescaled to sum to 1. 
If \code{FALSE}, and \code{p} does not sum to 1, an error is raised.}
}
\value{
A numeric value of the Upsilon Goodness-of-Fit statistic.
}
\description{
(FOR INTERNAL USE ONLY) 
  Calculates the Upsilon statistic for a 
  Goodness-of-Fit (GoF) test.
}
\details{
This statistic measures
  the discrepancy between observed counts and 
  expected probabilities.
}
\examples{
library("Upsilon")
counts <- c(10, 20, 30)
upsilon.gof.statistic(counts)
}
\keyword{internal}
