% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{aggregate_cov_data}
\alias{aggregate_cov_data}
\title{Aggregate data from the Vancouver Open Data Portal}
\usage{
aggregate_cov_data(
  dataset_id,
  select = "count(*) as count",
  group_by = NULL,
  where = NULL,
  apikey = getOption("VancouverOpenDataApiKey"),
  refresh = FALSE
)
}
\arguments{
\item{dataset_id}{Dataset id from the Vancouver Open Data catalogue}

\item{select}{Aggregation expression using
\href{https://help.opendatasoft.com/apis/ods-explore-v2/#section/Opendatasoft-Query-Language-(ODSQL)/Select-clause}{ODSQL syntax}.
Default `"count(*) as count"`.}

\item{group_by}{Grouping expression using
\href{https://help.opendatasoft.com/apis/ods-explore-v2/#section/Opendatasoft-Query-Language-(ODSQL)/Group-by-clause}{ODSQL syntax}.
Default `NULL` (no grouping).}

\item{where}{Filter expression using
\href{https://help.opendatasoft.com/apis/ods-explore-v2/#section/Opendatasoft-Query-Language-(ODSQL)/Where-clause}{ODSQL syntax}.
Default `NULL` (no filter).}

\item{apikey}{Vancouver Open Data API key, default `getOption("VancouverOpenDataApiKey")`}

\item{refresh}{Bypass the session cache and re-download, default `FALSE`}
}
\value{
A tibble with one row per group, with columns named according to the
  `select` expression.
}
\description{
Sends a server-side aggregation query to the CoV Open Data API and returns
the result as a tibble. Because aggregation is performed by the API, this is
suitable for summarising large datasets without downloading all records.

Results are cached for the duration of the R session.
}
\examples{
\dontrun{
# Count of each ticket status for fire hydrant infractions
aggregate_cov_data("parking-tickets-2017-2019",
                   group_by = "status",
                   where = "infractiontext LIKE 'FIRE'")

# Sum land and building values by tax year (server-side, no full download needed)
aggregate_cov_data("property-tax-report",
                   select = "sum(current_land_value) as Land,
                             sum(current_improvement_value) as Building",
                   group_by = "tax_assessment_year")
}

}
\seealso{
[get_cov_data()] to download full or filtered records,
  [search_cov_datasets()] to find dataset IDs
}
