% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnd_TMVN.R
\name{mvrandn}
\alias{mvrandn}
\title{Simulate truncated multivariate normal (TMVN) using the Vecchia approximation}
\usage{
mvrandn(
  lower,
  upper,
  mean,
  locs = NULL,
  covName = "matern15_isotropic",
  covParms = c(1, 0.1, 0),
  m = 30,
  sigma = NULL,
  N = 1000,
  verbose = FALSE
)
}
\arguments{
\item{lower}{lower bound vector for TMVN}

\item{upper}{upper bound vector for TMVN}

\item{mean}{MVN mean}

\item{locs}{location (feature) matrix n X d}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{m}{Vecchia conditioning set size}

\item{sigma}{dense covariance matrix, not needed when `locs` is not null}

\item{N}{number of samples required}

\item{verbose}{verbose level}
}
\value{
n X N matrix of generated samples
}
\description{
Simulate truncated multivariate normal (TMVN) using the Vecchia approximation
}
