% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmeticlogic.R
\name{02. Arithmetic and logic}
\alias{02. Arithmetic and logic}
\alias{+.vli}
\alias{-.vli}
\alias{*.vli}
\alias{/.vli}
\alias{\%\%.vli}
\alias{abs.vli}
\alias{^.vli}
\alias{>.vli}
\alias{<.vli}
\alias{>=.vli}
\alias{<=.vli}
\alias{==.vli}
\alias{!=.vli}
\title{Basic Arithmetic and Logical Operators for vli Objects}
\usage{
\method{+}{vli}(x, y)

\method{-}{vli}(x, y)

\method{*}{vli}(x, y)

\method{/}{vli}(x, y)

\method{\%\%}{vli}(x, y)

\method{abs}{vli}(x)

\method{^}{vli}(x, y)

\method{>}{vli}(x, y)

\method{<}{vli}(x, y)

\method{>=}{vli}(x, y)

\method{<=}{vli}(x, y)

\method{==}{vli}(x, y)

\method{!=}{vli}(x, y)
}
\arguments{
\item{x}{object of class vli or 32 bits integer}

\item{y}{object of class vli or 32 bits integer}
}
\value{
objects of class vli with the arithmetic operators; booleans with the logical operators
}
\description{
Basic arithmetic and logical operators for vli (Very Large Integers) objects.
}
\details{
As in the creation of vli objects (through the function \code{as.vli}), punctuation signs will be ignored (see the last example).

The algorithm implemented for the operator "\code{*}" computes the product with a trivial method when imput numbers have less than 40 digits and with the Karatsuba algorithm for fast multiplications when they are larger.
}
\examples{
x <- as.vli("712376544526091241")
x ^ 61
x / as.vli("4225234")
x > -x
x <= 10000000
13.2415 - as.vli(132415)
}
\author{
Javier Leiva Cuadrado
}
