% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_superiority.R
\name{probability_superiority}
\alias{probability_superiority}
\title{Probability of Superiority Calculation}
\usage{
probability_superiority(
  d = NULL,
  m1 = NULL,
  m2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  n1 = NULL,
  n2 = NULL,
  a = 0.05,
  t = NULL,
  model = NULL,
  df = NULL,
  x_col = NULL,
  y_col = NULL
)
}
\arguments{
\item{d}{the effect size}

\item{m1}{mean group one}

\item{m2}{mean group two}

\item{sd1}{standard deviation group one}

\item{sd2}{standard deviation group two}

\item{n1}{sample size group one}

\item{n2}{sample size group two}

\item{a}{significance level}

\item{t}{optional, calculate d from independent t, you must
include n1 and n2 for degrees of freedom}

\item{model}{optional, calculate d from t.test for independent t,
you must still include n1 and n2}

\item{df}{optional dataframe that includes the x_col and y_col}

\item{x_col}{name of the column that contains the factor levels OR
a numeric vector of group 1 scores}

\item{y_col}{name of the column that contains the dependent score OR
a numeric vector of group 2 scores}
}
\value{
The probability of superiority.
}
\description{
This function calculates the probability of superiority from
independent samples Cohen's d calculation.
}
\details{
You should provide one combination of the following:

1: d

2: m1 through n2

3: t, n1, n2

4: model, n1, n2

5: df, "x_col", "y_col"

6: x_col, y_col as numeric vectors
}
\examples{

probability_superiority(d = .25)

}
\keyword{effect}
\keyword{of}
\keyword{probability}
\keyword{size}
\keyword{superiority}
