% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_c_map.R
\name{visualize_c_map}
\alias{visualize_c_map}
\title{Visualization for Estimating c Bias + Estimates}
\usage{
visualize_c_map(
  dlow,
  r_values,
  d_values = NULL,
  f_values = NULL,
  f2_values = NULL,
  nnt_values = NULL,
  prob_values = NULL,
  prop_u1_values = NULL,
  prop_u2_values = NULL,
  prop_u3_values = NULL,
  prop_overlap_values = NULL,
  point_colors = c("red", "green", "blue"),
  size = 2,
  shape_1 = 2,
  shape_2 = 3,
  ribbon_color = "lightblue",
  lower = TRUE
)
}
\arguments{
\item{dlow}{The lower limit of the possible effect size (required).}

\item{r_values}{A vector of correlation values that are
possible (required).}

\item{d_values}{A vector of effect size values that are
possible.}

\item{f_values}{A vector of f effect size values that are
possible.}

\item{f2_values}{A vector of f2 effect size values that are
possible.}

\item{nnt_values}{A vector of number needed to treat
effect size values that are possible.}

\item{prob_values}{A vector of probability of superiority
effect size values that are possible.}

\item{prop_u1_values}{A vector of proportion of overlap u1
effect size values that are possible.}

\item{prop_u2_values}{A vector of proportion of overlap u2
effect size values that are possible.}

\item{prop_u3_values}{A vector of proportion of overlap u3
effect size values that are possible.}

\item{prop_overlap_values}{A vector of proportion of
distribution overlap effect size values that are possible.}

\item{point_colors}{A vector of color names or codes to plot
the effect sizes on the graph. You should use as many color
names/codes as you have max of an effect size (i.e, if r has 4, d has 3,
and prob has 5, then use 5 as the max number of colors).}

\item{size}{The size of the symbols on the chart.}

\item{shape_1}{a numeric value of one of the ggplot2 shapes}

\item{shape_2}{a numeric value of one of the ggplot2 shapes -
if you use different numbers, the two shapes are overlaid, as
we found this effect made it easier to read with many effect sizes
plotted on the same graph.}

\item{ribbon_color}{a color name or code to shade the area that
shows a non-zero effect in sensitivity.}

\item{lower}{Use this to indicate if you want the lower or upper bound
of d for one sided confidence intervals. If d is positive, you generally
want \code{lower = TRUE}, while negative d values should enter
\code{lower = FALSE} for the upper bound that is closer to zero (required).}
}
\value{
Returns a pretty graph of the possible effect size
and correlation combinations with the region of effect colored in.
Note that all effect sizes are converted to d for the graph.

\item{graph}{The graph of possible values for c}
}
\description{
This function displays a visualization of the possible
bias c that allows for a non-zero effect in sensitivity.
This function includes the ability to add values of
effect size and correlation to see how they map onto
the proposed c value.
}
\examples{

visualize_c_map(dlow = .25,
  d_values = c(.2, .3, .8),
  r_values = c(.1, .4, .3),
  lower = TRUE)

}
\keyword{effect}
\keyword{estimation}
\keyword{ggplot}
\keyword{size}
\keyword{visualization}
