% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_epiestim_model_functions.R
\name{fit_epiestim_model}
\alias{fit_epiestim_model}
\title{fit_epiestim_model - Function to estimate the reproduction number of an epidemic}
\usage{
fit_epiestim_model(
  data,
  window_size = 7L,
  type = NULL,
  mean_si = NULL,
  std_si = NULL,
  recon_opt = "match",
  method = "parametric_si",
  mean_prior = NULL,
  std_prior = NULL
)
}
\arguments{
\item{data}{\emph{data frame} containing two columns: date and confirm (number of cases)}

\item{window_size}{\emph{Integer} Length of the sliding windows used for R estimates.}

\item{type}{\emph{character} Specifies type of epidemic. Must be one of "flu_a", "flu_b", "rsv", "sars_cov2" or "custom"}

\item{mean_si}{\emph{Numeric} User specification of mean of parametric serial interval}

\item{std_si}{\emph{Numeric} User specification of standard deviation of parametric serial interval}

\item{recon_opt}{Not implemented. One of "naive" or "match" to pass on to {\code{\link[EpiEstim]{estimate_R}}} (see help page)}

\item{method}{One of "non_parametric_si", "parametric_si", "uncertain_si", "si_from_data" or "si_from_sample" to pass on to {\code{\link[EpiEstim]{estimate_R}}} (see help page)}

\item{mean_prior}{\emph{Numeric} positive number giving the mean of the common prior distribution for all reproduction numbers}

\item{std_prior}{\emph{Numeric} positive number giving the standard deviation of the common prior distribution for all reproduction numbers}
}
\value{
Object of class {\code{\link[EpiEstim]{estimate_R}}} (see \code{EpiEstim} help page)
}
\description{
A wrapper function for {\code{\link[EpiEstim]{estimate_R}}} from the \code{EpiEstim} library to estimate the reproduction number of epidemics to support short-term forecasts
}
\details{
\code{fit_epiestim_model} currently supports the following epidemics: Influenza, RSV and COVID-19. The default serial intervals for the estimation of R were retrieved from
Cowling et al., 2011, Vink et al., 2014 and Madewell et al., 2023 for Influenza A, Influenza B, RSV and COVID (BA.5 Omicron variant) respectively
}
