% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_functions.R
\name{generate_validation_metric}
\alias{generate_validation_metric}
\title{Compute Forecast Validation Metrics (SMAPE & MASE)}
\usage{
generate_validation_metric(data, validation_res)
}
\arguments{
\item{data}{A data frame used in \code{\link[=generate_validation]{generate_validation()}}, containing the
\strong{original training data} for the model. It must include:
\itemize{
\item \code{date}: Dates of the observed case data (class \code{Date}).
\item \code{confirm}: Numeric values of observed confirmed cases.
}}

\item{validation_res}{A list of forecast validation results, typically the
output from \code{\link[=generate_validation]{generate_validation()}}. Each element should contain:
\itemize{
\item \code{forecast_res_quantiles}: A data frame with columns \code{date} and \code{p50}
(median forecasted values).
\item \code{original_data}: A data frame representing the training data used for
that forecast, with a \code{date} column.
}}
}
\value{
A \code{tibble} (data frame) with one row per forecast result and the
following columns:
\itemize{
\item \code{train_period}: Date range of the training period used for the forecast.
\item \code{forecast_period}: Date range of the forecasted period.
\item \code{smape}: Symmetric Mean Absolute Percentage Error between forecasted and
actual values, rounded to two decimals.
\item \code{mase}: Mean Absolute Scaled Error, rounded to two decimals.
}
}
\description{
This function evaluates forecast accuracy across multiple validation runs
by computing two key performance metrics:
}
\details{
\itemize{
\item \strong{Symmetric Mean Absolute Percentage Error (SMAPE)}: Measures relative
forecast accuracy while remaining robust to zero values in the actual data.
\item \strong{Mean Absolute Scaled Error (MASE)}: Scales forecast errors relative
to the in-sample one-step naïve forecast, allowing comparison across
series with different scales.
}

For each forecast result, the function also reports the corresponding
training and forecast periods. Computation stops once the forecast period
reaches the maximum date in the model data.
\itemize{
\item \strong{SMAPE} is defined as:
\deqn{SMAPE = mean( |F - A| / ((|A| + |F|) / 2) )}
where \(A\) are actual values and \(F\) are forecasts.
It avoids division by zero and is suitable for count data with zeros.
\item \strong{MASE} compares the mean absolute forecast error against the mean
absolute difference of successive actual:
\deqn{MASE = mean(|A - F|) / mean(|diff(A)|)}
}

The function automatically excludes forecasts extending beyond the latest
date in the observed model data.
}
\examples{
data <- simulate_data()
formatted_data <- get_aggregated_data(data,"date", "flu_a", "2024-10-16", "2024-12-31")
start_date <- ("2024-10-16")
validation_results <- generate_validation(formatted_data, start_date, type ="flu_a")
generate_validation_metric(formatted_data, validation_results)

}
\seealso{
\code{\link[=generate_validation]{generate_validation()}}, \code{\link[=generate_forecast]{generate_forecast()}}
}
