% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_epiestim_model_functions.R
\name{project_epiestim_model}
\alias{project_epiestim_model}
\title{Extract daily forecast samples}
\usage{
project_epiestim_model(data, model_fit, n_days = 7, n_sim = 1000)
}
\arguments{
\item{data}{\emph{data frame} containing two columns: date and confirm (number of cases per day)}

\item{model_fit}{Object of class {\code{\link[EpiEstim]{estimate_R}}} generated by running \code{fit_epiestim_model}}

\item{n_days}{The number of days to run simulations for. Defaults to 14}

\item{n_sim}{The number of epicurves to simulate. Defaults to 1000}
}
\value{
Data-frame of daily forecast samples from all simulations
\describe{
\item{date}{date}
\item{incidence}{projected number of daily confirmed cases}
\item{sim}{simulation run number}
}
}
\description{
Function to produce short-term daily projections from objects of class {\code{\link[EpiEstim]{estimate_R}}}
}
