% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_plot.R
\name{ggplot.decomposition}
\alias{ggplot.decomposition}
\title{Decomposition ggplot Method}
\usage{
\method{ggplot}{decomposition}(
  data,
  mapping = aes(),
  type = c("full", "period", "classical"),
  size = 1.5,
  date_breaks = "2 year",
  date_labels = "\%y",
  plot_points = FALSE,
  ...
)
}
\arguments{
\item{data}{An object of class "decomposition".}

\item{mapping}{Default list of aesthetic mappings to use for plot. If not specified, must be supplied in each layer added to the plot.}

\item{type}{A character string. One of "full","period", or "classical". If "full", the full reconstruction is plotted. If "period", the reconstruction of each period is plotted individually. If "classical", the trend and seasonality are plotted.}

\item{size}{A number that represents the thickness of the lines being plotted}

\item{date_breaks}{A string to represent the distance between dates that the x-axis should be in. ex "1 month", "1 year"}

\item{date_labels}{A string to represent the format of the x-axis time labels.}

\item{plot_points}{a boolean to specify if the plot should be points or continous line.}

\item{...}{Additional arguments.}
}
\value{
A plot of the reconstruction in the "decomposition" class object.
}
\description{
Methods for plotting objects of the class "decomposition".
}
