% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{replicate_profiles}
\alias{replicate_profiles}
\title{Replicate profiles data.frame}
\usage{
replicate_profiles(
  profiles,
  replications,
  probabilities = NULL,
  replacement = TRUE,
  seed_used = NULL
)
}
\arguments{
\item{profiles}{data.frame of profiles}

\item{replications}{integer, final number of observations}

\item{probabilities}{vector of probabilities with the same length as the number of rows of profiles. Does not need to add up to 1 (are reweighted)}

\item{replacement}{Boolean whether replacement is used}

\item{seed_used}{Integer with the seed to be used for consistent results}
}
\value{
Resampled data.frame of profiles
}
\description{
Replicate profiles data.frame
}
\examples{
replicate_profiles(profiles=data.frame(id=1:100,age=rnorm(100,60,5)),
replications=200,probabilities=rep(1,100))
}
