% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{WMWssp_noether}
\alias{WMWssp_noether}
\title{Sample size calculation for the Wilcoxon-Mann-Whitney test using the Noether formula}
\usage{
WMWssp_noether(alpha, power, t, p, x = c(0), ties = FALSE)
}
\arguments{
\item{alpha}{two sided type I error rate}

\item{power}{power: detect a relative effect p at least with the specified power}

\item{t}{proportion of subjects in the first group (between 0 and 1)}

\item{p}{relative effect}

\item{x}{prior information is only needed in case of ties}

\item{ties}{TRUE if ties are possible (non continuous distribution), otherwise FALSE}
}
\value{
Returns an object from class WMWssp containing

\item{result}{A dataframe with the results.}

\item{t}{The allocation rate which was used.}

\item{alpha}{The type-I error rate which was used.}

\item{power}{The power which was used.}

\item{N}{The sample size needed.}
}
\description{
This function calculates the sample size for given type-I and type-II error probabilities using Noether's formula.
If ties are present then prior information is needen.
}
\examples{
# Prior information for the reference group
x <- c(315,375,356,374,412,418,445,403,431,410,391,475,379)
# generate data for treatment group based on a shift effect
y <- x - 20
# this data leads to a relative effect of p = 0.349

# calculate sampe size for a balanced design
ssp <- WMWssp_noether(alpha = 0.05, power = 0.8, t =1/2, p = 0.349)
summary(ssp)
}
\references{
Noether, G. E. (1987). Sample Size Determination for Some Common Nonparametric Tests. Journal of the American Statistical Association 85, 645.647.
}
\keyword{export}
