% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nobsplot.R
\name{nobsplot}
\alias{nobsplot}
\alias{nobsplot.default}
\alias{nobsplot.tidal}
\alias{nobsplot.tidalmean}
\title{Plot number of observations in a WRTDS interpolation grid}
\usage{
nobsplot(dat_in, ...)

\method{nobsplot}{default}(
  dat_in,
  month = "all",
  years = NULL,
  col_vec = NULL,
  allflo = TRUE,
  ncol = NULL,
  grids = FALSE,
  pretty = TRUE,
  ...
)

\method{nobsplot}{tidal}(dat_in, ...)

\method{nobsplot}{tidalmean}(dat_in, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to other methods}

\item{month}{numeric indicating months to plot or chr string 'all' to indicate all months with no plot facets}

\item{years}{numeric vector of years to plot, defaults to all}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}} and \code{\link[ggplot2]{scale_fill_gradientn}} for grid shading.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{allflo}{logical indicating if the salinity/flow values for plotting are limited to the fifth and ninety-fifth percentile of observed values for the month of interest}

\item{ncol}{numeric argument passed to \code{\link[ggplot2]{facet_wrap}} indicating number of facet columns}

\item{grids}{logical indicating if grid lines are present}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot number of observations for each point in a WRTDS interpolation grid.  This is a diagnostic plot to identify sample size for each unique location in the domain of the time series that is considered during model fitting.
}
\details{
The plots can be used sample size as an indication of model fit for each unique location in the domain space of the time series.  The plots show grids of the number of observations with weights greater than zero for each unique date and salinity/flow combination.  The \code{obs} attribute in the \code{tidal} or \code{tidalmean} object is created during model fitting and has the same dimensions as the interpolation grid.  Each row is a unique date in the original dataset and each column is a salinity/flow value used to fit each regression (i.e., values in the \code{flo_grd} attribute). In general, low points in the grid may indicate locations in the time series where insufficient data could affect model fit.

Unlike \code{\link{gridplot}}, interpolation of the grids for a smoother appearance is not allowed because the objective is to identify specific locations with low sample size.  For the former function, the objective is to characterize general trends over time rather values at specific locations.
}
\examples{
\dontrun{
## load a fitted tidal object
data(tidfit)

## default plot
nobsplot(tidfit)

## no facets, all months
nobsplot(tidfit)

## change the defaults
nobsplot(tidfit, tau = c(0.1), month = c(3, 6, 9, 12), 
 col_vec = c('red', 'blue', 'green'), flo_fac = 1)
 
## plot a tidalmean object
data(tidfitmean)

nobsplot(tidfitmean)

}
}
\seealso{
\code{\link{wtsplot}} for an alternative to evaluating weights with different window width combinations
}
