% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownloadET0fromDWD.R
\name{DownloadET0fromDWD}
\alias{DownloadET0fromDWD}
\title{Downloads daily reference evapotranspiration (ET0) grids from the
German Weather Service (DWD) open data portal for a given year,
extracts the values for a specified AOI (shapefile), and saves
the results as a .csv file with daily ET0 values.}
\usage{
DownloadET0fromDWD(
  target_path = NA,
  test_site_shp = NA,
  target_year = NA,
  timeout = 1000
)
}
\arguments{
\item{target_path}{Path to download and save csv-file with reference ET for your AOI and timespan of interest}

\item{test_site_shp}{Path to shapefile containing your AOI (string).}

\item{target_year}{year of interest (integer: 2021)}

\item{timeout}{time out span for downloading data (default: 10000, exceed, if your interconnection is slow)}
}
\value{
chart containing reference evapotranspiration for every DOY during given timespan
}
\description{
Downloads daily reference evapotranspiration (ET0) grids from the
German Weather Service (DWD) open data portal for a given year,
extracts the values for a specified AOI (shapefile), and saves
the results as a .csv file with daily ET0 values.
}
