% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genxicor.R
\name{genxicor}
\alias{genxicor}
\title{Compute the generalized cross rank increment correlation coefficient gxi.}
\usage{
genxicor(xmat, ymat)
}
\arguments{
\item{xmat}{Matrix of numeric values in the first argument.}

\item{ymat}{Matrix of numeric values in the second argument.}
}
\value{
Function returns the value of the genxi coefficient.
Since by default the option pvalue=TRUE is chosen, the function 
returns a list:
\describe{\item{xi}{The
value of the xi coefficient.}
\item{sd}{The standard deviation.}
\item{pval}{The test p-value.}
}
}
\description{
This function computes the generalized xi coefficient between two matrices
xmat and ymat.
There is a limitation on the size of the matrices, for the time
being, xmat and ymat can only have 31 columns.
If they are wider than 31, there is the option of using a
dimension reduction technique to bring the number of columns down
to 31, the first 31 components are then used.
The function encodes the data using a binary expansion and
then calls xicor on the vectors, so some of the arguments
relevant for xicor can be specified, such as pvalue.
}
\note{
This version does not use a seed as argument, if reproducibility is an issue, set a seed before calling the function.

The p-value of rejecting independence is set to TRUE.
}
\examples{

example_joint_calc = function(n,x=runif(n),y=runif(n),ep=runif(n)) {
u = (x + y + ep) \%\% 1
v = ((x + y)/2 + ep) \%\% 1
w = (4*x/3 + 2*y/3 + ep) \%\% 1
z = (2*x/3 + y/3 + ep) \%\% 1
q = cbind(u,v,w,z)
p = cbind(x,y)
c1 = genxicor(u, p)
c2 = genxicor(v, p)
c3 = genxicor(w, p)
c4 = genxicor(z, p)
c5 = genxicor(q, p)
return(list(marg1 = c1$xi, marg2 = c2$xi, marg3 = c3$xi, 
marg4 = c4$xi, joint = c5$xi, p1 = c1$pval, p2 = c2$pval, p3 = c3$pval,
p4 = c4$pval, p5 = c5$pval))
}
result1 <- example_joint_calc(n=10)

}
\references{
Chatterjee, S. (2022) <arXiv:2211.04702>
}
\author{
Sourav Chatterjee, Susan Holmes
}
\keyword{~htest}
\keyword{~methods}
