test_that("Tests around converting Excel cell references to row & column indices", {
  target <- matrix(c(5, 8, 14, 38), ncol = 2, byrow = TRUE)
  expect_equal(cref2idx(c("$H$5", "$AL$14")), target)
  expect_equal(idx2cref(c(5, 8, 14, 38)), c("$H$5", "$AL$14"))
  expect_equal(
    idx2cref(cref2idx(c("$KRE3799", "J$26789", "$DX$357")), absRow = FALSE, absCol = FALSE),
    c("KRE3799", "J26789", "DX357")
  )
  x <- c(36, 43, 25, 13, 356, 46)
  target <- matrix(x, ncol = 2, byrow = TRUE)
  expect_equal(cref2idx(idx2cref(x)), target)
})
