% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_analysis_sc.R
\name{construct_ppi_pcsf}
\alias{construct_ppi_pcsf}
\title{Construct Protein-protein interaction Network using Prize-Collecting Steiner Forest}
\usage{
construct_ppi_pcsf(
  g,
  prizes,
  w = 2,
  b = 1,
  mu = 5e-04,
  seed = 1,
  min_nodes = 1
)
}
\arguments{
\item{g}{An igraph object representing the base network.}

\item{prizes}{A named numeric vector of gene scores (prizes). Names must match vertex names in g.}

\item{w}{Numeric. Edge cost scaling weight. Default is 2.}

\item{b}{Numeric. Balance between prizes and edge costs. Default is 1.}

\item{mu}{Numeric. Trade-off parameter for sparsity. Default is 5e-04.}

\item{seed}{Integer. Random seed. Default is 1.}

\item{min_nodes}{Integer. Minimum number of nodes in subnetwork. Default is 1.}
}
\value{
An igraph object representing the extracted subnetwork. Returns NULL invisibly 
  if no prize genes are present, the subnetwork is too small, or the PCSF algorithm fails.

An igraph object representing the extracted subnetwork. Returns NULL invisibly if no prize genes are present, the subnetwork is too small, or the PCSF algorithm fails
}
\description{
Constructs a condition-specific gene regulatory network based on differential
expression results using the PCSF algorithm.
}
