% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get.data}
\alias{get.data}
\title{Download data for a specified data product}
\usage{
get.data(dp.id, site, month, save.dir)
}
\arguments{
\item{dp.id}{Parameter of class character. The data product code in question.
See \url{http://data.neonscience.org/data-product-catalog} for a complete list.}

\item{site}{Parameter of class character.
The NEON site data should be downloaded for.}

\item{month}{Parameter of class character. The year-month (e.g. "2017-01")
of the month to get data for.d, defaults to basic.}

\item{save.dir}{Optional, parameter of class character.
The local directory where data files should be saved.}
}
\value{
A list of named data frames
}
\description{
For the specified dates, site, package parameters,
and data product or name of family of data products,
data are downloaded and saved to the specifed directory.
}
\examples{
\dontrun{
cper_wind=Z10::get.data(site = "CPER", dp.id = "DP1.00002.001", month = "2017-04")
}
}
\seealso{
Currently none
}
\author{
Robert Lee \email{rhlee@colorado.edu}\cr
}
